if (GetVersion() < 1.1098) Abort("You need at least Sphere version 1.1098 to run this game")

EvaluateScript("managers.js")
EvaluateScript("game.js")
EvaluateScript("particle.js")
EvaluateScript("menus.js")
EvaluateScript("items.js")
EvaluateScript("people.js")
EvaluateScript("text.js")
EvaluateScript("shooter.js")
EvaluateScript("monster.js")
EvaluateScript("dungeon.js")
EvaluateScript("minimap.js")
EvaluateScript("fish.js")
EvaluateScript("build.js")
EvaluateScript("data.js")
EvaluateScript("script.js")

EvaluateScript("race.js")


loaded = false
lx = 0
ly = 0

GrassOff = false

const walk = 0
const attack_a = 1

Day = 1
Trips = 3

font = GetSystemFont()

GameArrow = LoadImage("point.png")

GameWindowStyle = LoadWindowStyle("window.rws")

People = new Array()
Player = 0

Timer = 0

DrawTimer = true

function game()
{
	Music.ChangeSong("Title.ogg")
	MainMenu()
	/*
	People.push( new Person("hero","hero.rss",ePlayerTouch,ePlayerHurt,ePlayerUpdate,16,16,true) )
	Player = People.length-1
  AttachCamera("hero");
  
  SetRenderScript("Render()")
  SetUpdateScript("Update()")
  UProcList.push(Input)
  UProcList.push(ProcParticles)
  UProcList.push(ProcPeople)
  UProcList.push(SpawnCheck)
  RProcList.push(RenderParticles)
  MapEngine("seaside.rmp", 60);
	*/
}

function NewGame(map)
{
	People.push( new Person("hero","hero.rss",ePlayerTouch,ePlayerHurt,ePlayerUpdate,16,16,true) )
	Player = People.length-1
  AttachCamera("hero");
  
  SetRenderScript("Render()")
  SetUpdateScript("Update()")
  UProcList.push(Input)
  UProcList.push(ProcParticles)
  UProcList.push(ProcPeople)
  UProcList.push(SpawnCheck)
  RProcList.push(RenderParticles)
  //RProcList.push(RenderHP)
  if (map == undefined)MapEngine("seaside.rmp", 60);
  //else { MapEngine(map, 60); }
}

mapt = LoadImage("blank.png")

function CheckTrips()
{
	if (Trips > 0)
		{
			Trips--;
			if (Trips != 1) TextBox(30,30,140,"You can take "+Trips+" more trips today!")
			else { TextBox(30,30,140,"You can take "+Trips+" more trip today!") }
			return true
		}
	else
		{
			if (TripCheck == false) TextBox(30,30,140,"You're too tired to take another trip, wait till tommorow!")
			TripCheck = true
			return false
		}
}

function SwapMap(map,x,y,fade)
{
	RemoveWeaponMod()

	lvl = People[Player].str+People[Player].dex+People[Player].lck
	
	AddWeaponMod()

	switch (map)
		{
			case "forest_area.rmp":
				if (lvl <= 9 && Flag[5] != true) map = "dungeon1.rmp"
				if (lvl >= 26 && Flag[7] != true) map = "dungeon2-1.rmp"
			break;	
		}

	if (fade == undefined) fade = true

	if (fade) FadeOut(500)
	
	EndTimer()
	SpawnList = []
	p = People[Player]
	DestroyPerson(p.name)
	People = new Array()
	People.unshift(p)
	CreatePerson(p.name, p.sprite, false);	
	ChangeMap(map)
	
	//Player = People.length-1
	if (x != undefined)
		{
			SetPersonX(p.name,x)
		}
	if (y != undefined)
		{
			SetPersonY(p.name,y)
		}		
	AttachCamera(p.name);
	UpdateMapEngine()
	//RenderMap()
	//FlipScreen()
	
	if (fade)FadeIn(500)
}

function Render()
{
	//font.drawText(10,30,"SpawnCount: "+SpawnList.length)
	RenderProcess_Manager_Run()
}

function Update()
{
	UpdateProcess_Manager_Run()
}

function Person(name,sprite,touch,hurt,update,x,y,create)
{

	this.name = name
	this.type = -1
	this.sprite = sprite
	this.weapon = sprite
	this.state = walk
	this.attack_time = 0
	this.invincible = false
	this.invincible_time = 0
	
	this.weapon_bonus_str = 0;
	this.weapon_bonus_dex = 0;
	this.weapon_bonus_lck = 0;
	
	this.weapon_number = 48
	
	this.weapon_anim = 0
	/*
	this.inventory = [new Item(Item_Database[0].name,Item_Database[0].description,Item_Database[0].action),
										new Item(Item_Database[1].name,Item_Database[1].description,Item_Database[1].action)]
	*/
	//this.inventory = [0,1,2,3,4,5,6,7,8,9,10,10,11,19,20,21,26,34,35,34,34,35,33,36,37,38,39,40,41,42,43,44]
	//this.inventory = [0,37,11,49,50,51,52,53,54,55,56,57,58]
	this.inventory = [0,37]
	//this.inventory = [0,37,49]
	//this.inventory = [34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35,37,37,36,36,36,36,43,44,44,44]
	this.velocity_x = 0
	this.velocity_y = 0
	
	this.delay = 0
	
	//this.mp = 0
	
	this.str = 3
	this.dex = 3
	this.lck = 3
	
	/*
	this.str = 100
	this.dex = 100
	this.lck = 5	
	*/
	this.getMaxHP = function()
										{
											hp = Math.floor( (this.str/4) + (this.dex/1.2) )+5
											if (hp <= 0) hp = 1
											return hp
										}
										
	this.MaxHPCheck = function()
											{
												if (this.hp > this.getMaxHP())
													{
														this.hp = this.getMaxHP()
													}
												if (this.hp < 0)
													{
														this.hp = 1
													}
											}
											
	this.hp = this.getMaxHP()
	
	//this.lvl = 1
	this.xp = 0
	this.gold = 0
	
	this.dead = false
	
	this.touch = touch
	
	this.hurt = hurt
	
	this.update = update
	
	this.brain = []
	
	if (create == true)
		{
			CreatePerson(name, sprite, true);
			
			SetPersonX(name,x)
			SetPersonY(name,y)
		}

}



function GetPlayerLevel()
{
	RemoveWeaponMod()

	points = 0;
	
	//for (var i = 0; i < People[Player].gold; i+=500)
	//	{
	//		points++
	//	}
		
	for (var i = 0; i < People[Player].str; i+=3)
		{
			points++
		}
		
	for (var i = 0; i < People[Player].dex; i+=3)
		{
			points++
		}			
		
	for (var i = 0; i < People[Player].lck; i+=2)
		{
			points++
		}				
				
	level = 0
	if (points > 10) level = 1
	if (points > 20) level = 2
	if (points > 30) level = 3
	
	AddWeaponMod()
	return level
}

function Random(lo,hi)
{
	hi++
	var random = lo += Math.floor(Math.random() * (hi - lo));
	return random
}

function PixelToTile(x,y)
{
	for (var i = 0; x > i*16; i++) {}
	x = i-1
	for (var i = 0; y > i*16; i++) {}
	y = i-1	
	return [x,y];
}

function FadeOut(msecs)
{

	var color = CreateColor(0,0,0,0);
	
	s = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255))
	s = s.createImage()
	
	timee = GetTime()
	RenderMap()
	FlipScreen()
	while (GetTime() - timee < msecs) 
		{
			color.alpha = (GetTime() - timee) * 255 / msecs;
			RenderMap()	
			s.blitMask(0,0,color)
			FlipScreen()
		}
}

function FadeOutMenu(msecs)
{

	var color = CreateColor(0,0,0,0);
	
	s = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255))
	i = GrabImage(0,0,320,240)
	s = s.createImage()
	
	timee = GetTime()
	i.blit(0,0)
	FlipScreen()
	while (GetTime() - timee < msecs) 
		{
			color.alpha = (GetTime() - timee) * 255 / msecs;
			i.blit(0,0)
			s.blitMask(0,0,color)
			FlipScreen()
		}
}

function FadeIn(msecs)
{
	var color = CreateColor(0,0,0,255);
	
	s = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255))
	s = s.createImage()
	
	timee = GetTime()
	s.blitMask(0,0,color)
	while (GetTime() - timee < msecs) 
		{
			color.alpha = - ( (GetTime() - timee) * 255 / msecs )
			RenderMap()		
			s.blitMask(0,0,color)
			FlipScreen()
		}
}

Music = new Object()
	//Music.File = LoadSound("Title.ogg") 
	//Music.oFile = LoadSound("Title.ogg") 
	Music.File = LoadSound("blank.ogg") 
	Music.oFile = LoadSound("blank.ogg") 	
	Music.FileName = ""
	Music.Mode = 0
	
	Music.File.setVolume(0)

	Music.Update = function()
								{
									if (Music.Mode == 0)
										{
											Music.oFile.setVolume( Music.oFile.getVolume() - 2 )
											
											if (Music.oFile.getVolume() <= 0)
												{
													//Abort("meh")
													Music.oFile.stop()
													Music.File.play(true)
													Music.File.setVolume( 0 )
													Music.Mode = 1
												}
										}
									else
										{
											Music.File.setVolume( Music.File.getVolume() + 2 )
											
											if (Music.File.getVolume() >= 255)
												{
													Music.RemoveUpdate()
												}										
										}
								}	
	
	Music.ChangeSong = function (song)
										{
											if (DoesSoundExist(song))
												{
													if (song != Music.FileName)
														{
															Music.oFile = Music.File
															Music.File = LoadSound(song)
															Music.FileName = song
															Music.Mode = 0
															
															UProcList.push(Music.Update)
														}
												}
											else
												{
													if (song != Music.FileName)
														{
															Music.oFile = Music.File
															Music.File = LoadSound("blank.ogg")
															Music.FileName = "blank.ogg"
															Music.Mode = 0
															
															UProcList.push(Music.Update)
														}												
												}
										}
										
	Music.RemoveUpdate = function()
											{
												for (var i = 0; i < UProcList.length; i++)
													{
														if (UProcList[i] == Music.Update) UProcList.splice(i,1) 
													}
											}
											
function DoesSoundExist(s)
{
	list = GetFileList("sounds")
	for (var i = 0; i < list.length; i++)
		{
			if (s == list[i]) return true
		}
	return false
}											
											
function RemoveWeaponMod()
{
	People[Player].str -= People[Player].weapon_bonus_str
	People[Player].dex -= People[Player].weapon_bonus_dex
	People[Player].lck -= People[Player].weapon_bonus_lck
}

function AddWeaponMod()
{
	People[Player].str += People[Player].weapon_bonus_str
	People[Player].dex += People[Player].weapon_bonus_dex
	People[Player].lck += People[Player].weapon_bonus_lck
}